<?php
    /**
    *
    * copyright (c) 2013-2022 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?id=34&alias=linee-guida-per-l%27uso-del-logo-geecom
    */

    class VisualizzatoreInvitoAzione extends VisualizzatoreComponente {
        private $impostazioniAspetto;
        private $classeContainer;
        private $impostazioniInvitoAzione;
        
        function __construct($db) {
            parent::__construct($db);
            $this->impostazioniAspetto = parent::getDb()->leggiSingolaRiga("geecB_impostazioni",1);
            $this->classeContainer     = "";
        }

        function creaSezione($dati) {
            $idSezione     = "";
            $classeSezione = "";
            $codiceColore  = "";
            $codiceImmagineSfondo = "";
            $codiceVideoSfondo    = "";
                
            $this->impostazioniInvitoAzione = parent::getDb()->leggiSingolaRiga("geec_invitiAzione",$dati["idElemento"]);
            
            if($dati["idSezione"]!="") {
                $idSezione = "id=\"{$dati["idSezione"]}\"";
            } 
            if($dati["classeSezione"]!="") {
                $classeSezione = "class=\"{$dati["classeSezione"]}\"";
            }

            if($dati["coloreSfondo"]!="") {
                $codiceColore = "style=\"background-color:{$dati["coloreSfondo"]};\"";
            }

            if($dati["immagineSfondo"]!="") {
                $codiceImmagineSfondo = "style=\"background-image:url({$dati["immagineSfondo"]});\"";

                $classeSezione = "class=\"{$dati["classeSezione"]} background-image\"";
            }

            if($dati["videoSfondo"]!="") {
                $codiceVideoSfondo = "data-vide-bg=\"mp4: {$dati["videoSfondo"]}, poster: {$dati["immagineSfondo"]}\" data-vide-options=\"posterType: jpg, loop: true, muted: true, position: 50% 50%\"";
            }
                
            if($this->impostazioniInvitoAzione["percorsoImmagine"]!="") {
                echo"<section $idSezione class=\"{$dati["classeSezione"]} background-image\" $codiceColore $codiceImmagineSfondo $codiceVideoSfondo >";
            }
            else {
                echo"<section $idSezione class=\"{$this->impostazioniInvitoAzione["altezza"]} d-flex justify-content-center align-items-center {$dati["classeSezione"]}\" $codiceColore $codiceImmagineSfondo $codiceVideoSfondo\">";
            }
            $classeContainer = ($dati["aTuttaLarghezza"]=="si") ? "" : "container";
            echo"<div class=\"$classeContainer\">
                    <div class=\"row\">"
                    . "<div class=\"{$this->impostazioniInvitoAzione["spazioOccupato"]}\">";
                        $this->generaContenutoSezione($dati);
                    echo"</div>
                    </div>
                </div>";
            echo"</section>";
        }
        
        function generaContenutoSezione($dati) {
            // se impostazioniInvitoAzione==null vuol dire che  non è stato eseguito creaSezione (accade all'interno sezione due colonne, tre colonne ecc)
            // in questo caso va eseguito il codice nell'if
            if($this->impostazioniInvitoAzione==null) {
                $this->impostazioniInvitoAzione = parent::getDb()->leggiSingolaRiga("geec_invitiAzione",$dati["idElemento"]);
                $this->classeContainer = "w-100";
            }
            
            if($this->impostazioniInvitoAzione["percorsoImmagine"]!="") {
                $this->stampaContenutoSezioneConSfondoImmagine($this->impostazioniInvitoAzione,$dati,$this->classeContainer);
            }
            else {
                $this->stampaContenutoSezioneConColoreSfondo($this->impostazioniInvitoAzione,$dati,$this->classeContainer);
            }
        }

        function stampaContenutoSezioneConSfondoImmagine($impostazioniInvitoAzione,$dati) {
            $linkImmagine = $this->impostazioniAspetto["urlSito"]."/".$impostazioniInvitoAzione["percorsoImmagine"];
            echo"<div class=\"$this->classeContainer\">
                    <div class=\"row\">
                        <div class=\"{$impostazioniInvitoAzione["altezza"]} d-flex justify-content-center align-items-center {$impostazioniInvitoAzione['spazioOccupato']} jarallax\" style=\"background-image:url('$linkImmagine')\">
                            <div class=\"row my-5 w-100\">
                                <div class=\"col-lg-8 mx-auto text-center\" data-aos=\"zoom-in\">
                                    {$impostazioniInvitoAzione["testo"]}";
                                    $this->stampaPulsante($impostazioniInvitoAzione);
                            echo"</div>
                            </div>
                        </div>
                    </div>
                </div>";
        }
        
        function stampaContenutoSezioneConColoreSfondo($impostazioniInvitoAzione,$dati) {   
            echo"<div class=\"$this->classeContainer\">
                        <div class=\"row my-5\">
                            <div class=\"col-sm-6 mx-auto text-center\" data-aos=\"zoom-in\">
                                {$impostazioniInvitoAzione["testo"]}";
                                $this->stampaPulsante($impostazioniInvitoAzione);
                        echo"</div>
                        </div>
                    </div>";
        }
        
        function stampaPulsante($impostazioniInvitoAzione) {
            if($impostazioniInvitoAzione["linkPulsante"]!="") {
                echo"<button type=button class=\"{$impostazioniInvitoAzione["stilePulsante"]}\" onclick=gestisciClick({$impostazioniInvitoAzione["id"]},'{$impostazioniInvitoAzione["linkPulsante"]}','incrementaClickInvitoAzione')> {$impostazioniInvitoAzione["titoloPulsante"]}</button>";
            }
        }
    }
